import pandas as pd
import logging
import csv
import copy
import os.path
import numpy as np
from IO.EssayPart import EssayPart


class EthoVision(EssayPart):

    dtypes = {
        #'PeriodType': 'category',
        #'Group': 'category',
        #'Session': 'category',
        #'MouseID': 'category'}
    }

    resample_how = {
         #'TrialCnt': EssayPart.lambda_most_common
    }

    def __init__(self, fileName):
        try:
            self.fileName = fileName
            fn, ext = os.path.splitext(self.fileName)
            if (ext == '.csv') or (ext == '.txt'):
                self.__readCSV(self.fileName)
            elif (ext == '.xls') or (ext == '.xlsx'):
                self.__readXLS(self.fileName)
            else:
                raise ValueError('Unknown file extension!')

            #Make this compatible with GnGExperiment
            self.meta = self.header
            self.meta.update({
                'MouseID': self.header['animal-nr'], 'Group': self.header['Group'],
                'Session': self.header['session']})

            #Add header information as columns, set some column types
            self.data.insert(0, 'MouseID', self.header['animal-nr'])
            self.data.insert(0, 'Session', self.header['session'])
            self.data.insert(0, 'Group', self.header['Group'])
            self.data.rename(columns={'Trial time': 'Time'}, inplace=True)
            #self.data['Time'] = pd.to_timedelta(self.data['Time'], unit='s')

            #self.data.index = pd.to_datetime(self.data['Time'], unit='s')
            self.data.index = pd.to_timedelta(self.data['Time'], unit='s')
            self.data.drop('Time', axis=1, inplace=True)

            how = self.autoDetectResampleMethods()
            how.update(self.resample_how)
            self.resample_how = how
            how = EssayPart.filterdic(self.resample_how, 'max')
            for c in how:
                self.createDiffColumn(c)

            #self.setdtype(self.dtypes)
            #self.data.drop('TrialNo', axis=1, inplace=True)
        except Exception as e:
            logging.error('Loading EthoVision RawData file failed! %s', e)

    def __repr__(self):
        return self.__str__()

    def __str__(self):
        return format('EthoVisionFile [%s] from %s for animal %s' % (self.fileName, self.header['Start time'], self.header['animal-nr']))

    def __readXLS(self, fileName):
        raise NotImplementedError('Not able to load excel sheets!')

    def __readCSV(self, fileName):
        try:
            #Read Header
            dFile = open(fileName, 'r')
            try:
                sample = dFile.readlines(1000)
            except UnicodeDecodeError:
                logging.info('Try to load EthoVisionRawData file with ISO-8859-1 encoding ...')
                dFile.close()
                dFile = open(fileName, 'r', encoding='ISO-8859-1')
                sample = dFile.readlines(1000)

            sample = ''.join(sample)
            if sample.count(',') > sample.count(';'):
                sep = ','
            else:
                sep = ';'

            logging.debug('Auto detected seperator to be "%c"', sep)
            dFile.seek(0)
            dReader = csv.reader(dFile, delimiter=sep)
            line = next(dReader)
            self.header = {}
            while line[0].strip() != '':
                self.header[line[0]] = line[1]
                line = next(dReader)

            dFile.close()

            #Skip Header and read the rest of the file
            nHeader = len(self.header.keys())
            skipLines = list(range(nHeader + 1))
            skipLines.append(nHeader + 2)  # The line containing the metric
            self.data = pd.read_csv(fileName, na_values=['-'], skiprows=skipLines, sep=sep)

            #Filter columns that only contain NAN
            r, c = self.data.shape
            nans = self.data.isnull().sum()
            for emptyC in nans[nans == r].index:
                logging.warning('Removing column %s!', emptyC)
                self.data.drop(emptyC, axis=1, inplace=True)
        except Exception as e:
            logging.error('CSV import of file failed! %s', e)
